function [Y, linedata] = computeY(text_file, A_b, V_b)
% admittance matrix calculus

%('* This script computes the Y matrix *');
%('*************************************************');
%%  Step 1: line parameters
% Load the line parameters from a text file.
linedata = load(text_file);

idx_from = linedata(:,1);
idx_to = linedata(:,2);
R_prime = linedata(:,3);
X_prime = linedata(:,4);
B_prime = linedata(:,5);
l = linedata(:,6);

% load transformer parameters from text file 
transformer_data = [];

if(~isempty(transformer_data))
    idx_1 = transformer_data(:,1);
    idx_2 = transformer_data(:,2);
    S_max = transformer_data(:,3);
    V_n1 = transformer_data(:,4);
    V_n2 = transformer_data(:,5);
    R_sc = transformer_data(:,6);
    X_sc = transformer_data(:,7);
else
    idx_1 = [];
    idx_2 = [];
    S_max = [];
    V_n1 = [];
    V_n2 = [];
    R_sc = [];
    X_sc = [];   
end

n_lines = length(idx_from); % number of lines
n_transfo = length(idx_1);	% number of transformers
n_nodes = max([idx_from;idx_to;idx_1;idx_2]);   % number of nodes

%%  Step 2: base values & pi-equivalent circuits

% Define the base power and base voltage here.
% The base current and base admittance are computed automatically.
Y_b = A_b / V_b^2;

% Construct the pi-section equivalent circuits, i.e. structs with fields
% i         start node
% j         end node
% Y_ij      branch admittance
% Y_i_ij    shunt admittance on start-node side
% Y_j_ij    shunt admittacne on end-node side
pi_lines = build_lines(idx_from,idx_to,R_prime,X_prime,B_prime,l,Y_b);
pi_transformers = build_transformers(idx_1,idx_2,S_max,V_n1,V_n2,R_sc,X_sc,Y_b);
pi_circuits = [pi_lines, pi_transformers].';

%%  Step 3: build primitive admittance matrices and incidence matrix
[A,Y_L,Y_T] = calculate_parameters(pi_circuits);

%%  Step 4: compute the nodal admittance matrix=
Y = A.' * Y_L * A + Y_T;

end
